/*===============================================================================================================*/
// ********************************** THESE ARE THE INFORMATIONS OF THE MAP: *********************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

// THE LAKE ERIE:
// CREATED BY DANY:
// SEPTEMBER 2007:

/*===============================================================================================================*/
// ********************************** MAIN ENTRY POINT FOR RANDOM MAP SCRIPT: ********************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

include "mercenaries.xs";
void main(void)
{

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.01);
/*===============================================================================================================*/
// ********************************* CHOOSES WHICH NATIVES APPEAR ON THE MAP: ********************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        int subCiv0=-1;
        int subCiv1=-1;
        		
/*---------------------------------------------------------------------------------------------------------------*/

        if (rmAllocateSubCivs(2) == true)
   {
		subCiv0=rmGetCivID("Lakota");
        if (subCiv0 >= 0)
        rmSetSubCiv(0, "Lakota");

		subCiv1=rmGetCivID("Lakota");
        if (subCiv1 >= 0)
        rmSetSubCiv(1, "Lakota"); 
   }		

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.05);
/*===============================================================================================================*/
// ******************************************* PICKS THE MAP SIZE: ********************************************* //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/
   
        int playerTiles=25000;
        
		int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
	    rmEchoInfo("Map size="+size+"m x "+size+"m");
	    rmSetMapSize(638, 638);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.10);
/*===============================================================================================================*/
// *************************************** DEFINE THE MAP PARAMETERS: ****************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

	    // PICKS A DEFAULT WATER HEIGHT:
	    rmSetSeaLevel(1.0);
		
		// SET MAP ELEVATION HEIGHT BLEND:
		rmSetMapElevationHeightBlend(1);
		
		// SET MAP ELEVATION PARAMETERS:
		// rmSetMapElevationParameters(long type, float minFrequency, long numberOctaves, float persistence, float heightVariation)
		rmSetMapElevationParameters(cElevTurbulence, 0.05, 6, 0.7, 8.0);
		
		// SET SEA TYPE:
		rmSetSeaType("great lakes");
		
		// ENABLE LOCAL WATER:
		rmEnableLocalWater(false);
		
		// SET BASE TERRAIN MIX:
		rmSetBaseTerrainMix("greatlakes_grass");
		    		
		// TERRAIN INITIALIZATION:
		rmTerrainInitialize("great_lakes\ground_grass1_gl", 1.0);
					    
		// SET LIGHTING:
		rmSetLightingSet("Great Lakes");
		
		// SET MAP TYPE:
		rmSetMapType("greatlakes");
		rmSetMapType("grass");
		rmSetMapType("water");
			    
		// SET WORLD CIRCLE CONSTRAINT:
		rmSetWorldCircleConstraint(true);
	    
		// CHOOSE THE MERCS:
		chooseMercs();

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.15);
/*===============================================================================================================*/
// *********************** DEFINE SOME CLASSES: THESE ARE USED LATER FOR CONSTRAINTS: ************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

	    int classPlayer=rmDefineClass("player");
		rmDefineClass("classCliff");
	    rmDefineClass("starting settlement");
	    rmDefineClass("startingUnit");
	    rmDefineClass("classForest");
	    rmDefineClass("importantItem");
	    rmDefineClass("natives");	
	    rmDefineClass("socketClass");
	    rmDefineClass("nuggets");
		rmDefineClass("center");
		rmDefineClass("region");
		rmDefineClass("classTrees");
		int classGreatLake=rmDefineClass("great lake");
		rmDefineClass("bay");
		int classIsland=rmDefineClass("island");
	
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.20);
/*===============================================================================================================*/
// ****************************************** DEFINE THE CONSTRAINTS: ****************************************** //
// ************************* THESE ARE USED TO HAVE OBJECTS AND AREAS AVOID EACH OTHER: ************************ //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/
// ********************************* DEFINE THE CONSTRAINTS FOR THE MAP EDGE: *********************************** //
/*----------------------------------------------------------------------------------------------------------------*/
   
        // MAP EDGE CONSTRAINTS:
        int edgeConstraint=rmCreatePieConstraint("edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.475), rmDegreesToRadians(0), rmDegreesToRadians(360));
		int edgeCloseConstraint=rmCreatePieConstraint("close edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.485), rmDegreesToRadians(0), rmDegreesToRadians(360));
		int edgeVeryCloseConstraint=rmCreatePieConstraint("very close edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.495), rmDegreesToRadians(0), rmDegreesToRadians(360));
		int edgeMediumCloseConstraint=rmCreatePieConstraint("medium edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.465), rmDegreesToRadians(0), rmDegreesToRadians(360));
		int edgeFarConstraint=rmCreatePieConstraint("far edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.455), rmDegreesToRadians(0), rmDegreesToRadians(360));
		int edgeVeryFarConstraint=rmCreatePieConstraint("very far edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.445), rmDegreesToRadians(0), rmDegreesToRadians(360));
		
/*----------------------------------------------------------------------------------------------------------------*/
// *************************** DEFINE THE CONSTRAINTS FOR THE PLAYER STARTING BASE: ***************************** //
/*----------------------------------------------------------------------------------------------------------------*/
		
        // PLAYER CONSTRAINTS:
        int playerConstraint=rmCreateClassDistanceConstraint("stuff vs. player", classPlayer, 15.0);
		int playerCloseConstraint=rmCreateClassDistanceConstraint("close stuff vs. player", classPlayer, 5.0);
        int playerVeryCloseConstraint=rmCreateClassDistanceConstraint("very close stuff vs. player", classPlayer, 2.0);
        int playerMediumConstraint=rmCreateClassDistanceConstraint("medium stuff vs. player", classPlayer, 25.0);
        int playerFarConstraint=rmCreateClassDistanceConstraint("far stuff vs. player", classPlayer, 50.0);
        int playerVeryFarConstraint=rmCreateClassDistanceConstraint("very far stuff vs. player", classPlayer, 75.0);
        
/*----------------------------------------------------------------------------------------------------------------*/
// **************************** DEFINE THE CONSTRAINTS FOR THE CARDINAL DIRECTIONS: ***************************** //		
/*----------------------------------------------------------------------------------------------------------------*/

        // CARDINAL DIRECTIONS CONSTRAINTS:
        int Northward=rmCreatePieConstraint("northMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(315), rmDegreesToRadians(135));
        int Southward=rmCreatePieConstraint("southMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(135), rmDegreesToRadians(315));
        int Eastward=rmCreatePieConstraint("eastMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(45), rmDegreesToRadians(225));
        int Westward=rmCreatePieConstraint("westMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(225), rmDegreesToRadians(45));

/*----------------------------------------------------------------------------------------------------------------*/
// *********************************** DEFINE THE CONSTRAINTS FOR THE CLIFFS: *********************************** //
/*----------------------------------------------------------------------------------------------------------------*/

        int avoidCliffs=rmCreateClassDistanceConstraint("stuff vs. cliff", rmClassID("classCliff"), 15.0);
	    int avoidCloseCliffs=rmCreateClassDistanceConstraint("close stuff vs. cliff", rmClassID("classCliff"), 5.0);
	    int avoidVeryCloseCliffs=rmCreateClassDistanceConstraint("very close stuff vs. cliff", rmClassID("classCliff"), 2.0);
		int avoidMediumCliffs=rmCreateClassDistanceConstraint("medium stuff vs. cliff", rmClassID("classCliff"), 25.0);
	    int avoidFarCliffs=rmCreateClassDistanceConstraint("far stuff vs. cliff", rmClassID("classCliff"), 50.0);
	    int avoidVeryFarCliffs=rmCreateClassDistanceConstraint("very far stuff vs. cliff", rmClassID("classCliff"), 75.0);

/*----------------------------------------------------------------------------------------------------------------*/
// ********************************* DEFINE THE CONSTRAINT OF THE BONUSISLAND: ********************************** //
/*----------------------------------------------------------------------------------------------------------------*/

        int islandConstraint=rmCreateClassDistanceConstraint("islands avoid each other", classIsland, 55.0);

		
/*----------------------------------------------------------------------------------------------------------------*/
// ********************************* DEFINE THE CONSTRAINTS FOR THE CENTER AREA: ******************************** //
/*----------------------------------------------------------------------------------------------------------------*/
		
        // CENTER AVOIDANCE:
		int centerConstraint=rmCreateClassDistanceConstraint("stay away from center", rmClassID("center"), 15.0);
	    int centerCloseConstraint=rmCreateClassDistanceConstraint("close stay away from center", rmClassID("center"), 5.0);
		int centerVeryCloseConstraint=rmCreateClassDistanceConstraint("very close stay away from center", rmClassID("center"), 2.0);
		int centerMediumConstraint=rmCreateClassDistanceConstraint("medium stay away from center", rmClassID("center"), 25.0);
	    int centerFarConstraint=rmCreateClassDistanceConstraint("far stay away from center", rmClassID("center"), 50.0);
        int centerVeryFarConstraint=rmCreateClassDistanceConstraint("very far stay away from center", rmClassID("center"), 75.0);

/*----------------------------------------------------------------------------------------------------------------*/
// ******************************** DEFINE THE CONSTRAINTS FOR THE REGION AREAS: ******************************** //
/*----------------------------------------------------------------------------------------------------------------*/
	    
        // REGION AVOIDANCE:
		int regionConstraint=rmCreateClassDistanceConstraint("stay away from region", rmClassID("region"), 15.0);
	    int regionCloseConstraint=rmCreateClassDistanceConstraint("close stay away from region", rmClassID("region"), 5.0);
		int regionVeryCloseConstraint=rmCreateClassDistanceConstraint("very close stay away from region", rmClassID("region"), 2.0);
		int regionMediumConstraint=rmCreateClassDistanceConstraint("medium stay away from region", rmClassID("region"), 25.0);
	    int regionFarConstraint=rmCreateClassDistanceConstraint("far stay away from region", rmClassID("region"), 50.0);
        int regionVeryFarConstraint=rmCreateClassDistanceConstraint("very far stay away from region", rmClassID("region"), 75.0);

/*----------------------------------------------------------------------------------------------------------------*/
// *********************************** DEFINE THE CONSTRAINTS FOR THE FORESTS: ********************************** //
/*----------------------------------------------------------------------------------------------------------------*/
		
		// FOREST AVOIDANCE:
        int forestConstraint=rmCreateClassDistanceConstraint("stuff vs. forest", rmClassID("classForest"), 15.0);
        int forestCloseConstraint=rmCreateClassDistanceConstraint("close vs. forest", rmClassID("classForest"), 5.0);
        int forestVeryCloseConstraint=rmCreateClassDistanceConstraint("very close vs. forest", rmClassID("classForest"), 2.0);
        int forestMediumConstraint=rmCreateClassDistanceConstraint("medium vs. forest", rmClassID("classForest"), 25.0);
        int forestFarConstraint=rmCreateClassDistanceConstraint("far vs. forest", rmClassID("classForest"), 50.0);
        int forestVeryFarConstraint=rmCreateClassDistanceConstraint("very far vs. forest", rmClassID("classForest"), 75.0);

/*----------------------------------------------------------------------------------------------------------------*/
// *********************************** DEFINE THE CONSTRAINTS FOR THE TREES: ************************************ //
/*----------------------------------------------------------------------------------------------------------------*/
		
		// TREES AVOIDANCE:
		int avoidTrees=rmCreateClassDistanceConstraint("stuff avoid Trees", rmClassID("classTrees"), 15.0);
		int avoidCloseTrees=rmCreateClassDistanceConstraint("close avoid Trees", rmClassID("classTrees"), 5.0);
		int avoidVeryCloseTrees=rmCreateClassDistanceConstraint("very close avoid Trees", rmClassID("classTrees"), 2.0);
		int avoidMediumTrees=rmCreateClassDistanceConstraint("medium avoid Trees", rmClassID("classTrees"), 25.0);
		int avoidFarTrees=rmCreateClassDistanceConstraint("far avoid Trees", rmClassID("classTrees"), 50.0);
		int avoidVeryFarTrees=rmCreateClassDistanceConstraint("very far avoid Trees", rmClassID("classTrees"), 75.0);
	
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// FISHES AVOIDANCE:
		int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "fish", 15.0);
		int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
		
		// WHALES AVOIDANCE:
		int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale v whale", "minkeWhale", 35.0);
		int whaleLand = rmCreateTerrainDistanceConstraint("whale v. land", "land", true, 20.0);
		
		// NEW EXTRA STUFF FOR WATER SPAWN POINT AVOIDANCE:
	    int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	    int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
				
/*----------------------------------------------------------------------------------------------------------------*/
// ******************************** DEFINE THE CONSTRAINTS FOR THE LIVESTOCKS: ********************************** //		
/*----------------------------------------------------------------------------------------------------------------*/
        		        
		// SHEEP AVOIDANCE:
		int avoidSheep=rmCreateTypeDistanceConstraint("stuff avoids sheep", "sheep", 15.0);
        int avoidCloseSheep=rmCreateTypeDistanceConstraint("close stuff avoids sheep", "sheep", 5.0);
		int avoidMediumSheep=rmCreateTypeDistanceConstraint("medium stuff avoids sheep", "sheep", 25.0);
		int avoidVeryCloseSheep=rmCreateTypeDistanceConstraint("very close stuff avoids sheep", "sheep", 2.0);
		int avoidFarSheep=rmCreateTypeDistanceConstraint("far stuff avoids sheep", "sheep", 50.0);
        int avoidVeryFarSheep=rmCreateTypeDistanceConstraint("very far stuff avoids sheep", "sheep", 75.0);
       
/*----------------------------------------------------------------------------------------------------------------*/
// **************************** DEFINE THE CONSTRAINTS FOR THE NORTH AMERICAN FOOD: ***************************** //
/*----------------------------------------------------------------------------------------------------------------*/		
				
		// MOOSE AVOIDANCE:
		int avoidMoose=rmCreateTypeDistanceConstraint("stuff avoids moose", "moose", 15.0);
        int avoidCloseMoose=rmCreateTypeDistanceConstraint("close stuff avoids moose", "moose", 5.0);
		int avoidVeryCloseMoose=rmCreateTypeDistanceConstraint("very close stuff avoids moose", "moose", 2.0);
		int avoidMediumMoose=rmCreateTypeDistanceConstraint("medium stuff avoids moose", "moose", 25.0);
		int avoidFarMoose=rmCreateTypeDistanceConstraint("far stuff avoids moose", "moose", 50.0);
		int avoidVeryFarMoose=rmCreateTypeDistanceConstraint("very Far stuff avoids moose", "moose", 75.0);
		
		// DEER AVOIDANCE:
		int avoidDeer=rmCreateTypeDistanceConstraint("stuff avoids deer", "deer", 15.0);
        int avoidCloseDeer=rmCreateTypeDistanceConstraint("close stuff avoids deer", "deer", 5.0);
		int avoidVeryCloseDeer=rmCreateTypeDistanceConstraint("very close stuff avoids deer", "deer", 2.0);
		int avoidMediumDeer=rmCreateTypeDistanceConstraint("medium stuff avoids deer", "deer", 25.0);
		int avoidFarDeer=rmCreateTypeDistanceConstraint("far stuff avoids deer", "deer", 50.0);
		int avoidVeryFarDeer=rmCreateTypeDistanceConstraint("very Far stuff avoids deer", "deer", 75.0);
		    		
/*----------------------------------------------------------------------------------------------------------------*/
// *********************************** DEFINE THE CONSTRAINTS FOR THE MONEY: ************************************ //		
/*----------------------------------------------------------------------------------------------------------------*/
	    		
		// SILVER COIN AVOIDANCE:
		int avoidCoin=rmCreateTypeDistanceConstraint("stuff avoids coin", "mine", 15.0);
		int avoidCloseCoin=rmCreateTypeDistanceConstraint("close stuff avoids coin", "mine", 5.0);
		int avoidVeryCloseCoin=rmCreateTypeDistanceConstraint("very close stuff avoids coin", "mine", 2.0);
		int avoidMediumCoin=rmCreateTypeDistanceConstraint("medium stuff avoids coin", "mine", 25.0);
		int avoidFarCoin=rmCreateTypeDistanceConstraint("far stuff avoids coin", "mine", 50.0);
		int avoidVeryFarCoin=rmCreateTypeDistanceConstraint("very far stuff avoids coin", "mine", 75.0);
	
		// STARTING COIN AVOIDANCE:
		int avoidStartingCoin=rmCreateTypeDistanceConstraint("starting coin avoids coin", "gold", 22.0);
  		
/*----------------------------------------------------------------------------------------------------------------*/
// ********************************** DEFINE THE CONSTRAINTS FOR THE FRUITS: ************************************ //
/*----------------------------------------------------------------------------------------------------------------*/		
				
		// FRUITS AVOIDANCE:
		int avoidFruits=rmCreateTypeDistanceConstraint("stuff avoid fruits", "berrybush", 15.0);
		int avoidCloseFruits=rmCreateTypeDistanceConstraint("close avoid fruits", "berrybush", 5.0);
		int avoidVeryCloseFruits=rmCreateTypeDistanceConstraint("very close avoid fruits", "berrybush", 2.0);
		int avoidMediumFruits=rmCreateTypeDistanceConstraint("medium avoid fruits", "berrybush", 25.0);
		int avoidFarFruits=rmCreateTypeDistanceConstraint("far avoid fruits", "berrybush", 50.0);
		int avoidVeryFarFruits=rmCreateTypeDistanceConstraint("very far avoid fruits", "berrybush", 75.0);
		
/*----------------------------------------------------------------------------------------------------------------*/
// ********************************* DEFINE THE CONSTRAINTS FOR THE TREASURES: ********************************** //
/*----------------------------------------------------------------------------------------------------------------*/
        
		// NUGGET AVOIDANCE:
		int avoidNugget=rmCreateTypeDistanceConstraint("stuff avoid nugget", "AbstractNugget", 15.0);
        int avoidCloseNugget=rmCreateTypeDistanceConstraint("close stuff avoid nugget", "AbstractNugget", 5.0);
        int avoidVeryCloseNugget=rmCreateTypeDistanceConstraint("very close stuff avoid nugget", "AbstractNugget", 2.0);
        int avoidMediumNugget=rmCreateTypeDistanceConstraint("medium stuff avoid nugget", "AbstractNugget", 25.0);
        int avoidFarNugget=rmCreateTypeDistanceConstraint("far stuff avoid nugget", "AbstractNugget", 50.0);
        int avoidVeryFarNugget=rmCreateTypeDistanceConstraint("very far stuff avoid nugget", "AbstractNugget", 75.0);
        		
/*----------------------------------------------------------------------------------------------------------------*/
// ******************************* DEFINE THE CONSTRAINTS FOR THE IMPASSABLE LAND: ****************************** //
/*----------------------------------------------------------------------------------------------------------------*/

		// AVOID IMPASSABLE LAND:
        int avoidImpassableLand=rmCreateTerrainDistanceConstraint("stuff avoid impassable land", "Land", false, 15.0);
        int avoidCloseImpassableLand=rmCreateTerrainDistanceConstraint("close stuff avoid impassable land", "Land", false, 5.0);
        int avoidVeryCloseImpassableLand=rmCreateTerrainDistanceConstraint("very close stuff avoid impassable land", "Land", false, 2.0);
        int avoidMediumImpassableLand=rmCreateTerrainDistanceConstraint("medium stuff avoid impassable land", "Land", false, 25.0);
        int avoidFarImpassableLand=rmCreateTerrainDistanceConstraint("far stuff avoid impassable land", "Land", false, 50.0);
        int avoidVeryFarImpassableLand=rmCreateTerrainDistanceConstraint("very far stuff avoid impassable land", "Land", false, 75.0);

/*----------------------------------------------------------------------------------------------------------------*/
// ******************************* DEFINE THE CONSTRAINTS FOR THE STARTING UNITS: ******************************* //		
/*----------------------------------------------------------------------------------------------------------------*/

        // UNIT AVOIDANCE - FOR THINGS THAT AREN'T IN THE STARTING RESOURCES:
        int avoidStartingUnits=rmCreateClassDistanceConstraint("objects avoid starting units", rmClassID("startingUnit"), 15.0);
        int avoidCloseStartingUnits=rmCreateClassDistanceConstraint("close objects avoid starting units", rmClassID("startingUnit"), 5.0);
        int avoidVeryCloseStartingUnits=rmCreateClassDistanceConstraint("very close objects avoid starting units", rmClassID("startingUnit"), 2.0);
        int avoidMediumStartingUnits=rmCreateClassDistanceConstraint("medium objects avoid starting units", rmClassID("startingUnit"), 25.0);
        int avoidFarStartingUnits=rmCreateClassDistanceConstraint("far objects avoid starting units", rmClassID("startingUnit"), 50.0);
        int avoidVeryFarStartingUnits=rmCreateClassDistanceConstraint("very far objects avoid starting units", rmClassID("startingUnit"), 75.0);
      
/*----------------------------------------------------------------------------------------------------------------*/		
// ********************************* DEFINE THE CONSTRAINTS FOR THE DECORATIONS: ******************************** //
/*----------------------------------------------------------------------------------------------------------------*/

        // DECORATION AVOIDANCE:
        int avoidAll=rmCreateTypeDistanceConstraint("stuff avoid all", "all", 10.0);
		int avoidCloseAll=rmCreateTypeDistanceConstraint("close stuff avoid all", "all", 5.0);
		int avoidVeryCloseAll=rmCreateTypeDistanceConstraint("very close stuff avoid all", "all", 2.0);
		int avoidMediumAll=rmCreateTypeDistanceConstraint("medium stuff avoid all", "all", 25.0);
		int avoidFarAll=rmCreateTypeDistanceConstraint("far stuff avoid all", "all", 50.0);
		int avoidVeryFarAll=rmCreateTypeDistanceConstraint("very far stuff avoid all", "all", 75.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
// ***************************** DEFINE THE CONSTRAINTS FOR THE IMPORTANT ITEMS: ******************************** //
/*----------------------------------------------------------------------------------------------------------------*/
        
        // IMPORTANT ITEM AVOIDANCE:
		int avoidImportantItem=rmCreateClassDistanceConstraint("stuff avoids important item", rmClassID("importantItem"), 15.0);
        int avoidCloseImportantItem=rmCreateClassDistanceConstraint("close stuff avoids important item", rmClassID("importantItem"), 5.0);
        int avoidVeryCloseImportantItem=rmCreateClassDistanceConstraint("very close stuff avoids important item", rmClassID("importantItem"), 2.0);
        int avoidMediumImportantItem=rmCreateClassDistanceConstraint("medium stuff avoids important item", rmClassID("importantItem"), 25.0);
        int avoidFarImportantItem=rmCreateClassDistanceConstraint("far stuff avoids important item", rmClassID("importantItem"), 50.0);
        int avoidVeryFarImportantItem=rmCreateClassDistanceConstraint("very far stuff avoids important item", rmClassID("importantItem"), 75.0);
        
/*----------------------------------------------------------------------------------------------------------------*/
// ******************************* DEFINE THE CONSTRAINTS FOR THE TRADE ROUTE: ********************************** //
/*----------------------------------------------------------------------------------------------------------------*/		
       
        // VP AVOIDANCE:
        int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("stuff avoid trade route", 15.0);
		int avoidCloseTradeRoute = rmCreateTradeRouteDistanceConstraint("close stuff avoid trade route", 5.0);
        int avoidVeryCloseTradeRoute = rmCreateTradeRouteDistanceConstraint("very close stuff avoid trade route", 2.0);
        int avoidMediumTradeRoute = rmCreateTradeRouteDistanceConstraint("medium stuff avoid trade route", 25.0);
        int avoidFarTradeRoute = rmCreateTradeRouteDistanceConstraint("far stuff avoid trade route", 50.0);
        int avoidVeryFarTradeRoute = rmCreateTradeRouteDistanceConstraint("very far stuff avoid trade route", 75.0);
       
/*----------------------------------------------------------------------------------------------------------------*/
// *********************************** DEFINE THE CONSTRAINTS FOR THE SOCKET: *********************************** //        		
/*----------------------------------------------------------------------------------------------------------------*/

	    // SOCKET AVOIDANCE:
		int avoidSocket=rmCreateClassDistanceConstraint("stuff avoid socket", rmClassID("socketClass"), 15.0);
	    int avoidCloseSocket=rmCreateClassDistanceConstraint("close stuff avoid socket", rmClassID("socketClass"), 5.0);
	    int avoidVeryCloseSocket=rmCreateClassDistanceConstraint("very close avoid socket", rmClassID("socketClass"), 2.0);
	    int avoidMediumSocket=rmCreateClassDistanceConstraint("medium avoid socket", rmClassID("socketClass"), 25.0);
	    int avoidFarSocket=rmCreateClassDistanceConstraint("far stuff avoid socket", rmClassID("socketClass"), 50.0);
	    int avoidVeryFarSocket=rmCreateClassDistanceConstraint("very far stuff avoid socket", rmClassID("socketClass"), 75.0);
	   
/*----------------------------------------------------------------------------------------------------------------*/		
// ********************************** DEFINE THE CONSTRAINT FOR THE NATIVES: ************************************ //
/*----------------------------------------------------------------------------------------------------------------*/
	
	    // NATIVES AVOIDANCE:
	    int avoidNatives = rmCreateClassDistanceConstraint("stuff avoid Natives", rmClassID("natives"), 15.0);
	    int avoidCloseNatives = rmCreateClassDistanceConstraint("close stuff avoid Natives", rmClassID("natives"), 5.0);
	   	int avoidVeryCloseNatives = rmCreateClassDistanceConstraint("very close stuff avoid Natives", rmClassID("natives"), 2.0);
	   	int avoidMediumNatives = rmCreateClassDistanceConstraint("medium stuff avoid Natives", rmClassID("natives"), 25.0);
	   	int avoidFarNatives = rmCreateClassDistanceConstraint("far stuff avoid Natives", rmClassID("natives"), 50.0);
	   	int avoidVeryFarNatives = rmCreateClassDistanceConstraint("very far stuff avoid Natives", rmClassID("natives"), 75.0);
	   	
/*----------------------------------------------------------------------------------------------------------------*/
// ****************************** DEFINE THE CONSTRAINT FOR THE CIRCLE CONSTRAINT: ****************************** //
/*----------------------------------------------------------------------------------------------------------------*/

	    // CIRCLE CONSTRAINT:
		int circleConstraint=rmCreatePieConstraint("circle Constraint", 0.5, 0.5, 0, rmZFractionToMeters(0.47), rmDegreesToRadians(0), rmDegreesToRadians(360));

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.25);
/*===============================================================================================================*/
// ************************************* DEFINE AND PLACE THE TRADE ROUTE: ************************************* //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        // DEFINE AND PLACE TRADE ROUTE 1:
		int tradeRouteID = rmCreateTradeRoute();
        int socketID=rmCreateObjectDef("sockets to dock Trade Posts south");
        rmSetObjectDefTradeRouteID(socketID, tradeRouteID);

        rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
	    rmSetObjectDefAllowOverlap(socketID, true);
        rmAddObjectDefToClass(socketID, rmClassID("socketClass"));
        rmSetObjectDefMinDistance(socketID, 0.0);
        rmSetObjectDefMaxDistance(socketID, 12.0);

	    rmAddTradeRouteWaypoint(tradeRouteID, 0.225, 0.825);
		rmAddTradeRouteWaypoint(tradeRouteID, 0.475, 0.925);
		rmAddTradeRouteWaypoint(tradeRouteID, 0.800, 0.800);
		rmAddTradeRouteWaypoint(tradeRouteID, 0.925, 0.475);
		rmAddTradeRouteWaypoint(tradeRouteID, 0.825, 0.225);
	    
        bool placedTradeRoute = rmBuildTradeRoute(tradeRouteID, "dirt");
        if(placedTradeRoute == false)
        rmEchoError("Failed to place trade route"); 
  
	    // ADD THE SOCKETS ALONG THE TRADE ROUTE:
		
		rmPlaceObjectDefAtLoc(socketID, 0, 0.225, 0.825);
		rmPlaceObjectDefAtLoc(socketID, 0, 0.475, 0.925);
		rmPlaceObjectDefAtLoc(socketID, 0, 0.800, 0.800);
		rmPlaceObjectDefAtLoc(socketID, 0, 0.925, 0.475);
		rmPlaceObjectDefAtLoc(socketID, 0, 0.825, 0.225);

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.30);
/*===============================================================================================================*/
// **************************************** DEFINE AND PLACE THE AREAS: **************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/
 
    	// THE MICHIGAN LAKE:
		int michiganID=rmCreateArea("Lake Michigan 1");
      	rmSetAreaWaterType(michiganID, "new england lake");
	    rmSetAreaSize(michiganID, 0.265, 0.265);
		rmSetAreaCoherence(michiganID, 0.85);
	    rmSetAreaLocation(michiganID, 0.50, 0.50);
	    //rmAddAreaInfluencePoint(michiganID, 0.55, 0.48);
	
	    rmAddAreaToClass(michiganID, classGreatLake);
	    rmSetAreaBaseHeight(michiganID, 1.0);
	    rmSetAreaObeyWorldCircleConstraint(michiganID, false);
	    rmSetAreaMinBlobs(michiganID, 1);
	    rmSetAreaMaxBlobs(michiganID, 1);
	    rmSetAreaMinBlobDistance(michiganID, 1);
	    rmSetAreaMaxBlobDistance(michiganID, 1);
	    rmSetAreaSmoothDistance(michiganID, 0);
	    rmBuildArea(michiganID);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // BONUS ISLAND:
        int bonusIslandID=rmCreateArea("The Island of Fear");
		rmSetAreaSize(bonusIslandID, 0.080, 0.080);
        //rmSetAreaSize(bonusIslandID, rmAreaTilesToFraction(450), rmAreaTilesToFraction(450));
        rmSetAreaTerrainType(bonusIslandID, "great_lakes\ground_grass1_gl");
        rmSetAreaMix(bonusIslandID, "greatlakes_grass");
		rmAddAreaToClass(bonusIslandID, classIsland);
	    rmSetAreaBaseHeight(bonusIslandID, 2.0);
        rmSetAreaSmoothDistance(bonusIslandID, 5);
        rmSetAreaWarnFailure(bonusIslandID, false);
	    rmSetAreaMinBlobs(bonusIslandID, 1);
        rmSetAreaMaxBlobs(bonusIslandID, 1);
        rmSetAreaMinBlobDistance(bonusIslandID, 1);
	    rmSetAreaMaxBlobDistance(bonusIslandID, 1);
        rmSetAreaCoherence(bonusIslandID, 0.875);
        rmAddAreaConstraint(bonusIslandID, islandConstraint);
	
		rmSetAreaLocation(bonusIslandID, 0.50, 0.50);
	
        rmBuildArea(bonusIslandID);

        // add island constraints
        int bonusIslandConstraint=rmCreateAreaConstraint("bonus Island", bonusIslandID);
        //int southIslandConstraint=rmCreateAreaConstraint("south Island", southIslandID);		

/*----------------------------------------------------------------------------------------------------------------*/


        // DEFINE AND PLACE A CENTER AREA: 		
		int centerID=rmCreateArea("The Center Area");
        rmSetAreaSize(centerID, 0.080, 0.080);
        rmSetAreaLocation(centerID, 0.5, 0.5);
		rmSetAreaCoherence(centerID, 1.0);
        rmAddAreaToClass(centerID, rmClassID("center"));
		//rmSetAreaMix(centerID, "rockies_snow");
        rmBuildArea(centerID); 
	
/*---------------------------------------------------------------------------------------------------------------*/

        // DEFINE AND PLACE REGION AREA 1: 		
		int region1ID=rmCreateArea("Region Area 1");
        rmSetAreaSize(region1ID, 0.005, 0.005);
        rmSetAreaLocation(region1ID, 0.15, 0.75);
		rmSetAreaCoherence(region1ID, 1.0);
        rmAddAreaToClass(region1ID, rmClassID("region"));
		//rmSetAreaMix(region1ID, "rockies_snow");
        rmBuildArea(region1ID); 
		
/*---------------------------------------------------------------------------------------------------------------*/

		// DEFINE AND PLACE REGION AREA 2: 		
		int region2ID=rmCreateArea("Region Area 2");
        rmSetAreaSize(region2ID, 0.005, 0.005);
        rmSetAreaLocation(region2ID, 0.75, 0.15);
		rmSetAreaCoherence(region2ID, 1.0);
        rmAddAreaToClass(region2ID, rmClassID("region"));
		//rmSetAreaMix(region2ID, "rockies_snow");
        rmBuildArea(region2ID); 

/*---------------------------------------------------------------------------------------------------------------*/
/*
        // DEFINE AND PLACE REGION AREA 3: 		
		int region3ID=rmCreateArea("Region Area 3");
        rmSetAreaSize(region3ID, 0.003, 0.003);
        rmSetAreaLocation(region3ID, 0.20, 0.60);
		rmSetAreaCoherence(region3ID, 1.0);
        rmAddAreaToClass(region3ID, rmClassID("region"));
		//rmSetAreaMix(region3ID, "rockies_snow");
        rmBuildArea(region3ID); 
*/
/*---------------------------------------------------------------------------------------------------------------*/
/*
        // DEFINE AND PLACE REGION AREA 4: 		
		int region4ID=rmCreateArea("Region Area 4");
        rmSetAreaSize(region4ID, 0.003, 0.003);
        rmSetAreaLocation(region4ID, 0.60, 0.20);
		rmSetAreaCoherence(region4ID, 1.0);
        rmAddAreaToClass(region4ID, rmClassID("region"));
		//rmSetAreaMix(region4ID, "rockies_snow");
        rmBuildArea(region4ID); 
*/
/*---------------------------------------------------------------------------------------------------------------*/
/*
        // DEFINE AND PLACE REGION AREA 5: 		
		int region5ID=rmCreateArea("Region Area 5");
        rmSetAreaSize(region5ID, 0.003, 0.003);
        rmSetAreaLocation(region5ID, 0.40, 0.80);
		rmSetAreaCoherence(region5ID, 1.0);
        rmAddAreaToClass(region5ID, rmClassID("region"));
		//rmSetAreaMix(region5ID, "rockies_snow");
        rmBuildArea(region5ID); 
*/
/*---------------------------------------------------------------------------------------------------------------*/
/*
        // DEFINE AND PLACE REGION AREA 6: 		
		int region6ID=rmCreateArea("Region Area 6");
        rmSetAreaSize(region6ID, 0.003, 0.003);
        rmSetAreaLocation(region6ID, 0.80, 0.40);
		rmSetAreaCoherence(region6ID, 1.0);
        rmAddAreaToClass(region6ID, rmClassID("region"));
		//rmSetAreaMix(region6ID, "rockies_snow");
        rmBuildArea(region6ID); 		
*/
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.35);
/*===============================================================================================================*/
// **************************************** SET UP THE PLAYER LOCATIONS: *************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        int whichTeam=rmRandInt(1,2);
		
		if ( whichTeam == 1 )
	{	
		rmSetPlacementTeam(0);
		rmSetPlacementSection(0.90, 0.35); 
		rmPlacePlayersCircular(0.075, 0.075, 0); 
		
		rmSetPlacementTeam(1);
		rmSetPlacementSection(0.575, 0.675);
		rmPlacePlayersCircular(0.40, 0.40, 0); 
	}	
		else
	{	
		rmSetPlacementTeam(0);
		rmSetPlacementSection(0.575, 0.675);
		rmPlacePlayersCircular(0.40, 0.40, 0); 
		
		rmSetPlacementTeam(1);
		rmSetPlacementSection(0.90, 0.35); 
		rmPlacePlayersCircular(0.075, 0.075, 0); 
	}	
		


/*===============================================================================================================*/
// ***************************************** SET UP THE PLAYER AREAS: ****************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        float playerFraction=rmAreaTilesToFraction(1750);
        for(i=1; <cNumberPlayers)
   {
        // CREATE THE AREA:
        int id=rmCreateArea("Player"+i);
        
		// ASSIGN TO THE PLAYER:
        rmSetPlayerArea(i, id);
        
		// SET THE SIZE:
        rmSetAreaSize(id, playerFraction, playerFraction);
        
		// ADD AREA TO CLASS:
		rmAddAreaToClass(id, classPlayer);
		
		// SET AREA MIX:
		//rmSetAreaMix(id, "great plains drygrass");
        
		// SET AREA MIN AND MAX BLOBS:
		rmSetAreaMinBlobs(id, 1);
        rmSetAreaMaxBlobs(id, 1);
        
		// ADD AREA CONSTRAINT:
		rmAddAreaConstraint(id, playerConstraint); 
                
		// SET AREA LOC PLAYER:
		rmSetAreaLocPlayer(id, i);
        
		// SET AREA WARN FAILURE:
		rmSetAreaWarnFailure(id, false);
		
		// SET AREA COHERENCE:
		rmSetAreaCoherence(id, 1.0);
		
		// SET AREA MIX:
		//rmSetAreaMix(id, "rockies_snow");
		
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "rockies\groundsnow1_roc");
   }
        // Build the areas.
        rmBuildAllAreas();

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.40);
/*===============================================================================================================*/
// *********************************** DEFINE AND PLACE SOME OTHER AREAS: ************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.45);
/*===============================================================================================================*/
// ****************** DEFINE THE STARTING TCID AND THE STARTING UNITS AND STARTING RESOURCES: ****************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/
        
		// DEFINE THE STARTING STARTING UNITS:
	    int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	    rmSetObjectDefMinDistance(startingUnits, 7.0);
	    rmSetObjectDefMaxDistance(startingUnits, 12.0);

	    // DEFINE THE STARTING TCID:
		int startingTCID = rmCreateObjectDef("startingTC");
	    if ( rmGetNomadStart())
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	}
	    else
	{
		rmAddObjectDefItem(startingTCID, "TownCenter", 1, 0.0);
	}
	    rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(startingTCID, 0.0);
	    rmSetObjectDefMaxDistance(startingTCID, 0.0);
	    rmAddObjectDefConstraint(startingTCID, avoidTradeRoute);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.50);
/*===============================================================================================================*/
// ********************* PLACE THE STARTING TCID AND STARTING UNITS AND STARTING RESOURCES: ******************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        for(i=1; <cNumberPlayers)
	{
		// PLACE THE STARTING TCID:
		rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
				
		// PLACE THE STARTING UNITS:
		rmPlaceObjectDefAtLoc(startingUnits, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
	}
/*----------------------------------------------------------------------------------------------------------------*/	
	
	    for(i=1; <cNumberPlayers)
	{	
		// DEFINE TWO PLAYER SILVER MINES:
		// EVERYONE GETS TWO ORE OBJECTDEF, ONE PRETTY CLOSE, THE OTHER A LITTLE FURTHER AWAY:
		int silverType = -1;
	    int playerGoldID = -1;
		silverType = rmRandInt(1,10);
		playerGoldID = rmCreateObjectDef("player silver closer "+i);
		rmAddObjectDefItem(playerGoldID, "mine", 1, 0.0);
		rmAddObjectDefToClass(playerGoldID, rmClassID("startingUnit"));
		// rmAddObjectDefToClass(playerGoldID, rmClassID("importantItem"));
		//rmAddObjectDefConstraint(playerGoldID, avoidTradeRoute);
		rmAddObjectDefConstraint(playerGoldID, avoidStartingCoin);
		rmAddObjectDefConstraint(playerGoldID, avoidCloseStartingUnits);
		rmSetObjectDefMinDistance(playerGoldID, 15.0);
		rmSetObjectDefMaxDistance(playerGoldID, 20.0);
		
		// PLACE TWO PLAYER SILVER MINES:
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	}	
	
/*----------------------------------------------------------------------------------------------------------------*/

        for(i=1; <cNumberPlayers)
	{	
		// DEFINING THE STARTING TREES:
		int StartAreaTreeID=rmCreateObjectDef("starting trees"+i);
	    rmAddObjectDefItem(StartAreaTreeID, "TreeGreatLakes", 1, 0.0);
		rmAddObjectDefToClass(StartAreaTreeID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(StartAreaTreeID, 12.0);
	    rmSetObjectDefMaxDistance(StartAreaTreeID, 18.0);
	    rmAddObjectDefConstraint(StartAreaTreeID, avoidCloseStartingUnits);

        // PLACING THE STARTING TREES:
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	}

/*----------------------------------------------------------------------------------------------------------------*/	
	
        for(i=1; <cNumberPlayers)
	{	
		// DEFINING THE STARTING COWS:
		int StartCowID=rmCreateObjectDef("starting cow"+i);
	    rmAddObjectDefItem(StartCowID, "cow", 4, 4.0);
		rmAddObjectDefToClass(StartCowID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(StartCowID, 10.0);
	    rmSetObjectDefMaxDistance(StartCowID, 12.0);
	    rmSetObjectDefCreateHerd(StartCowID, true);
	    rmAddObjectDefConstraint(StartCowID, avoidCloseStartingUnits);

        // PLACING THE STARTING COWS:
		rmPlaceObjectDefAtLoc(StartCowID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	}	
	
/*----------------------------------------------------------------------------------------------------------------*/

        for(i=1; <cNumberPlayers)
	{	
		// DEFINING THE STARTING BERRIES:
		int StartBerriesID=rmCreateObjectDef("starting berries"+i);
	    rmAddObjectDefItem(StartBerriesID, "berrybush", 4, 4.0);
		rmAddObjectDefToClass(StartBerriesID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(StartBerriesID, 15.0);
	    rmSetObjectDefMaxDistance(StartBerriesID, 17.0);
	    rmSetObjectDefCreateHerd(StartBerriesID, true);
	    rmAddObjectDefConstraint(StartBerriesID, avoidCloseStartingUnits);

        // PLACING THE STARTING BERRIES:
		rmPlaceObjectDefAtLoc(StartBerriesID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	}		
 
/*================================================================================================================*/
        
		for(i=1; <cNumberPlayers)
	{	
		
		// DEFINE THE WATER FLAG ID:		
		int waterFlagID=-1;
		
		// DEFINE VECTOR TCLOC:
		vector TCLoc = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));

        // DEFINE THE WATER FLAG ID:
		waterFlagID=rmCreateObjectDef("HC water flag "+i);
		rmAddObjectDefItem(waterFlagID, "HomeCityWaterSpawnFlag", 1, 0.0);
		rmAddClosestPointConstraint(flagVsFlag);
		rmAddClosestPointConstraint(flagLand);
		vector TCLocation = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));
        vector closestPoint = rmFindClosestPointVector(TCLocation, rmXFractionToMeters(1.0));

		// PLACE THE WATER FLAG ID:
		rmPlaceObjectDefAtLoc(waterFlagID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
		
		// CLEAR CLOSEST POINT CONSTRAINTS:
		rmClearClosestPointConstraints();	

	}	
   
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.55);
/*===============================================================================================================*/
// ******************************* DEFINE AND PLACE THE NATIVE AMERICAN TRIBES: ******************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        if (subCiv0 == rmGetCivID("Lakota"))
	{  
		int lakota1VillageID = -1;
		lakota1VillageID = rmCreateGrouping("lakota village 1", "native lakota village 1");
		rmSetGroupingMinDistance(lakota1VillageID, 0.0);
		rmSetGroupingMaxDistance(lakota1VillageID, 0.0);
		rmAddGroupingToClass(lakota1VillageID, rmClassID("natives"));
		rmAddGroupingConstraint(lakota1VillageID, avoidNatives);
		
		rmPlaceGroupingAtLoc(lakota1VillageID, 0, 0.15, 0.75);
	} 
	
/*----------------------------------------------------------------------------------------------------------------*/

        if (subCiv1 == rmGetCivID("Lakota"))
	{  
		int lakota2VillageID = -1;
		lakota2VillageID = rmCreateGrouping("lakota village 2", "native lakota village 1");
		rmSetGroupingMinDistance(lakota2VillageID, 0.0);
		rmSetGroupingMaxDistance(lakota2VillageID, 0.0);
		rmAddGroupingToClass(lakota2VillageID, rmClassID("natives"));
		rmAddGroupingConstraint(lakota2VillageID, avoidNatives);
		
		rmPlaceGroupingAtLoc(lakota2VillageID, 0, 0.75, 0.15);
	} 	

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.60);
/*================================================================================================================*/
// ************************** DEFINE AND PLACE SOME RANDOM NORTHERN AND SOUTHERN CLIFFS: ************************ //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        int numTries = -1;
	    int failCount = -1;
		
		if (cNumberNonGaiaPlayers<=2)
		numTries=cNumberNonGaiaPlayers*4;
		else
		numTries=cNumberNonGaiaPlayers*2;
	    failCount=0;
	    
		for(i=0; <numTries)
{	
		int Cliff1ID=rmCreateArea("The Cliff 1"+i);
	    rmSetAreaSize(Cliff1ID, 0.0015, 0.0015);
		rmSetAreaWarnFailure(Cliff1ID, false);
		rmSetAreaCliffType(Cliff1ID, "New England");
		rmAddAreaToClass(Cliff1ID, rmClassID("classCliff"));		
		//rmSetAreaCliffEdge(Cliff1ID, 1, 0.6, 0.1, 1.0, 0);
        rmSetAreaCliffEdge(Cliff1ID, 1, 1.0, 0.1, 1.0, 0);		
		rmSetAreaCliffPainting(Cliff1ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(Cliff1ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(Cliff1ID, 1.0);
		rmAddAreaTerrainLayer(Cliff1ID, "new_england\ground4_ne", 0, 2);
        rmSetAreaSmoothDistance(Cliff1ID, 15);
		rmSetAreaCoherence(Cliff1ID, 0.85);
		
		rmAddAreaConstraint(Cliff1ID, avoidImportantItem);
		rmAddAreaConstraint(Cliff1ID, avoidTradeRoute);
		rmAddAreaConstraint(Cliff1ID, avoidSocket);
		rmAddAreaConstraint(Cliff1ID, edgeConstraint);
		rmAddAreaConstraint(Cliff1ID, avoidImpassableLand);
		rmAddAreaConstraint(Cliff1ID, centerConstraint);
		rmAddAreaConstraint(Cliff1ID, regionConstraint);
		rmAddAreaConstraint(Cliff1ID, avoidAll);
		rmAddAreaConstraint(Cliff1ID, avoidVeryFarCliffs);
		rmAddAreaConstraint(Cliff1ID, Northward);
		rmAddAreaConstraint(Cliff1ID, playerCloseConstraint);
				  	    		
		if(rmBuildArea(Cliff1ID)==false)
		{
			// Stop trying once we fail 3 times in a row
			failCount++;
			if(failCount==3)
				break;
		}
		else
			failCount=0;
	}
        		
/*----------------------------------------------------------------------------------------------------------------*/		

		for(i=0; <numTries)
	{	
		int Cliff2ID=rmCreateArea("The Cliff 2"+i);
	    rmSetAreaSize(Cliff2ID, 0.0015, 0.0015);
		rmSetAreaWarnFailure(Cliff2ID, false);
		rmSetAreaCliffType(Cliff2ID, "New England");
		rmAddAreaToClass(Cliff2ID, rmClassID("classCliff"));		
		//rmSetAreaCliffEdge(Cliff2ID, 1, 0.6, 0.1, 1.0, 0);
        rmSetAreaCliffEdge(Cliff2ID, 1, 1.0, 0.1, 1.0, 0);			
		rmSetAreaCliffPainting(Cliff2ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(Cliff2ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(Cliff2ID, 1.0);
		rmAddAreaTerrainLayer(Cliff2ID, "new_england\ground4_ne", 0, 2);
        rmSetAreaSmoothDistance(Cliff2ID, 15);
		rmSetAreaCoherence(Cliff2ID, 0.85);
		
		rmAddAreaConstraint(Cliff2ID, avoidImportantItem);
		rmAddAreaConstraint(Cliff2ID, avoidTradeRoute);
		rmAddAreaConstraint(Cliff2ID, avoidSocket);
		rmAddAreaConstraint(Cliff2ID, edgeConstraint);
		rmAddAreaConstraint(Cliff2ID, avoidImpassableLand);
		rmAddAreaConstraint(Cliff2ID, centerConstraint);
		rmAddAreaConstraint(Cliff2ID, regionConstraint);
		rmAddAreaConstraint(Cliff2ID, avoidAll);
		rmAddAreaConstraint(Cliff2ID, avoidVeryFarCliffs);
		rmAddAreaConstraint(Cliff2ID, Southward);
		rmAddAreaConstraint(Cliff2ID, playerCloseConstraint);
		
		if(rmBuildArea(Cliff2ID)==false)
		{
			// Stop trying once we fail 3 times in a row
			failCount++;
			if(failCount==3)
				break;
		}
		else
			failCount=0;
		
	}	

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.65);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE FASTCOIN MINES: ************************************* //   
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN MINES:
		int CoinsID= rmCreateObjectDef("The Coins 1"); 
	    rmAddObjectDefItem(CoinsID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(CoinsID, 0.0);
	    rmSetObjectDefMaxDistance(CoinsID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(CoinsID, avoidImpassableLand);
		rmAddObjectDefConstraint(CoinsID, avoidVeryFarCoin);
		rmAddObjectDefConstraint(CoinsID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(CoinsID, centerCloseConstraint);
		rmAddObjectDefConstraint(CoinsID, regionConstraint);
		rmAddObjectDefConstraint(CoinsID, avoidTradeRoute);
	    rmAddObjectDefConstraint(CoinsID, avoidSocket);
	    rmAddObjectDefConstraint(CoinsID, avoidCloseCliffs);
	    rmAddObjectDefConstraint(CoinsID, circleConstraint);
		rmAddObjectDefConstraint(CoinsID, Northward);
  	    rmAddObjectDefConstraint(CoinsID, avoidAll);
	    
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(CoinsID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(CoinsID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// THE SOUTHERN MINES:
		int Coins2ID= rmCreateObjectDef("The Coins 2"); 
	    rmAddObjectDefItem(Coins2ID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(Coins2ID, 0.0);
	    rmSetObjectDefMaxDistance(Coins2ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(Coins2ID, avoidImpassableLand);
		rmAddObjectDefConstraint(Coins2ID, avoidVeryFarCoin);
		rmAddObjectDefConstraint(Coins2ID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(Coins2ID, centerCloseConstraint);
		rmAddObjectDefConstraint(Coins2ID, regionConstraint);
		rmAddObjectDefConstraint(Coins2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(Coins2ID, avoidSocket);
	    rmAddObjectDefConstraint(Coins2ID, avoidCloseCliffs);
	    rmAddObjectDefConstraint(Coins2ID, circleConstraint);
		rmAddObjectDefConstraint(Coins2ID, Southward);
  	    rmAddObjectDefConstraint(Coins2ID, avoidAll);
	    
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(Coins2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(Coins2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);

/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE NUGGETS: **************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN NUGGETS:
		int nuggetID= rmCreateObjectDef("nugget 1"); 
	    rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
	    rmSetObjectDefMinDistance(nuggetID, 0.0);
	    rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
  	    rmAddObjectDefConstraint(nuggetID, avoidVeryFarNugget);
		rmAddObjectDefConstraint(nuggetID, avoidCloseCoin);
		rmAddObjectDefConstraint(nuggetID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(nuggetID, centerCloseConstraint);
		rmAddObjectDefConstraint(nuggetID, regionConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
	    rmAddObjectDefConstraint(nuggetID, avoidSocket);
	    rmAddObjectDefConstraint(nuggetID, avoidCloseCliffs);
	    rmAddObjectDefConstraint(nuggetID, circleConstraint);
		rmAddObjectDefConstraint(nuggetID, Northward);
  	    rmAddObjectDefConstraint(nuggetID, avoidAll);
	    
		rmSetNuggetDifficulty(1, 4);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// THE SOUTHERN NUGGETS:
		int nugget2ID= rmCreateObjectDef("nugget 2"); 
	    rmAddObjectDefItem(nugget2ID, "Nugget", 1, 0.0);
	    rmSetObjectDefMinDistance(nugget2ID, 0.0);
	    rmSetObjectDefMaxDistance(nugget2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(nugget2ID, avoidImpassableLand);
  	    rmAddObjectDefConstraint(nugget2ID, avoidVeryFarNugget);
		rmAddObjectDefConstraint(nugget2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(nugget2ID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(nugget2ID, centerCloseConstraint);
		rmAddObjectDefConstraint(nugget2ID, regionConstraint);
		rmAddObjectDefConstraint(nugget2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(nugget2ID, avoidSocket);
	    rmAddObjectDefConstraint(nugget2ID, avoidCloseCliffs);
	    rmAddObjectDefConstraint(nugget2ID, circleConstraint);
		rmAddObjectDefConstraint(nugget2ID, Southward);
  	    rmAddObjectDefConstraint(nugget2ID, avoidAll);
	    
		rmSetNuggetDifficulty(1, 4);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);

/*================================================================================================================*/
// ************************************** DEFINE AND PLACE THE BERRYBUSH: *************************************** //		
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN BERRYBUSH:
		int BerriesID=rmCreateObjectDef("The Berries 1");
        rmAddObjectDefItem(BerriesID, "berrybush", rmRandInt(3,7), 8.0);
        rmSetObjectDefMinDistance(BerriesID, 0.0);
        rmSetObjectDefMaxDistance(BerriesID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(BerriesID, regionConstraint);
		rmAddObjectDefConstraint(BerriesID, avoidVeryFarFruits);
		rmAddObjectDefConstraint(BerriesID, avoidCloseCoin);
		rmAddObjectDefConstraint(BerriesID, centerCloseConstraint);
        rmAddObjectDefConstraint(BerriesID, avoidAll);
		rmAddObjectDefConstraint(BerriesID, avoidCloseCliffs);
		rmAddObjectDefConstraint(BerriesID, playerCloseConstraint);
		rmAddObjectDefConstraint(BerriesID, Northward);
        rmAddObjectDefConstraint(BerriesID, avoidImpassableLand);
	    rmAddObjectDefConstraint(BerriesID, avoidTradeRoute);
	    rmAddObjectDefConstraint(BerriesID, avoidSocket);
	    rmAddObjectDefConstraint(BerriesID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(BerriesID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(BerriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(BerriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
	    
/*----------------------------------------------------------------------------------------------------------------*/
		
		// THE SOUTHERN BERRYBUSH:
		int Berries2ID=rmCreateObjectDef("The Berries 2");
        rmAddObjectDefItem(Berries2ID, "berrybush", rmRandInt(3,7), 8.0);
        rmSetObjectDefMinDistance(Berries2ID, 0.0);
        rmSetObjectDefMaxDistance(Berries2ID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(Berries2ID, regionConstraint);
		rmAddObjectDefConstraint(Berries2ID, avoidVeryFarFruits);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(Berries2ID, centerCloseConstraint);
        rmAddObjectDefConstraint(Berries2ID, avoidAll);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseCliffs);
		rmAddObjectDefConstraint(Berries2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(Berries2ID, Southward);
        rmAddObjectDefConstraint(Berries2ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(Berries2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(Berries2ID, avoidSocket);
	    rmAddObjectDefConstraint(Berries2ID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(Berries2ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(Berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(Berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);

/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE DEER HERDS: **************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN DEER HERDS:
		int deer1ID=rmCreateObjectDef("deer herd 1");
        rmAddObjectDefItem(deer1ID, "deer", rmRandInt(6,9), 10.0);
        rmSetObjectDefMinDistance(deer1ID, 0.0);
        rmSetObjectDefMaxDistance(deer1ID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(deer1ID, regionConstraint);
		rmAddObjectDefConstraint(deer1ID, centerCloseConstraint);
        rmAddObjectDefConstraint(deer1ID, avoidVeryFarDeer);
	    rmAddObjectDefConstraint(deer1ID, avoidAll);
		rmAddObjectDefConstraint(deer1ID, avoidCloseCliffs);
		rmAddObjectDefConstraint(deer1ID, avoidCloseFruits);
		rmAddObjectDefConstraint(deer1ID, avoidCloseCoin);
		rmAddObjectDefConstraint(deer1ID, playerCloseConstraint);
		rmAddObjectDefConstraint(deer1ID, Northward);
        rmAddObjectDefConstraint(deer1ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(deer1ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(deer1ID, avoidSocket);
	    rmAddObjectDefConstraint(deer1ID, avoidCloseNugget);
        rmSetObjectDefCreateHerd(deer1ID, true);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(deer1ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(deer1ID, 0, 0.5, 0.5, 1.25*cNumberNonGaiaPlayers);
       
/*----------------------------------------------------------------------------------------------------------------*/
		
		// THE SOUTHERN DEER HERDS:
		int deer2ID=rmCreateObjectDef("deer herd 2");
        rmAddObjectDefItem(deer2ID, "deer", rmRandInt(6,9), 10.0);
        rmSetObjectDefMinDistance(deer2ID, 0.0);
        rmSetObjectDefMaxDistance(deer2ID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(deer2ID, regionConstraint);
		rmAddObjectDefConstraint(deer2ID, centerCloseConstraint);
        rmAddObjectDefConstraint(deer2ID, avoidVeryFarDeer);
	    rmAddObjectDefConstraint(deer2ID, avoidAll);
		rmAddObjectDefConstraint(deer2ID, avoidCloseCliffs);
		rmAddObjectDefConstraint(deer2ID, avoidCloseFruits);
		rmAddObjectDefConstraint(deer2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(deer2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(deer2ID, Northward);
        rmAddObjectDefConstraint(deer2ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(deer2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(deer2ID, avoidSocket);
	    rmAddObjectDefConstraint(deer2ID, avoidCloseNugget);
        rmSetObjectDefCreateHerd(deer2ID, true);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(deer2ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(deer2ID, 0, 0.5, 0.5, 1.25*cNumberNonGaiaPlayers);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.70);
/*================================================================================================================*/
// ************************************* DEFINE AND PLACE THE MOOSE HERDS: ************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTH MOOSE HERD:
		int moose1ID=rmCreateObjectDef("moose herd 1");
        rmAddObjectDefItem(moose1ID, "moose", rmRandInt(6,10), 8.0);
        rmSetObjectDefMinDistance(moose1ID, 0.0);
        rmSetObjectDefMaxDistance(moose1ID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(moose1ID, avoidVeryFarMoose);
		rmAddObjectDefConstraint(moose1ID, avoidFarDeer);
	    rmAddObjectDefConstraint(moose1ID, avoidAll);
		rmAddObjectDefConstraint(moose1ID, avoidCloseFruits);
		rmAddObjectDefConstraint(moose1ID, avoidCloseCoin);
		rmAddObjectDefConstraint(moose1ID, edgeCloseConstraint);
		rmAddObjectDefConstraint(moose1ID, playerCloseConstraint);
		rmAddObjectDefConstraint(moose1ID, regionConstraint);
		rmAddObjectDefConstraint(moose1ID, centerCloseConstraint);
		rmAddObjectDefConstraint(moose1ID, Northward);
		rmAddObjectDefConstraint(moose1ID, avoidCloseCliffs);
        rmAddObjectDefConstraint(moose1ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(moose1ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(moose1ID, avoidSocket);
	    rmAddObjectDefConstraint(moose1ID, avoidCloseNugget);
        rmSetObjectDefCreateHerd(moose1ID, true);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(moose1ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(moose1ID, 0, 0.5, 0.5, 1.25*cNumberNonGaiaPlayers);		
	    		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// THE SOUTH MOOSE HERD:
		int moose2ID=rmCreateObjectDef("moose herd 2");
        rmAddObjectDefItem(moose2ID, "moose", rmRandInt(6,10), 8.0);
        rmSetObjectDefMinDistance(moose2ID, 0.0);
        rmSetObjectDefMaxDistance(moose2ID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(moose2ID, avoidVeryFarMoose);
		rmAddObjectDefConstraint(moose2ID, avoidFarDeer);
	    rmAddObjectDefConstraint(moose2ID, avoidAll);
		rmAddObjectDefConstraint(moose2ID, avoidCloseFruits);
		rmAddObjectDefConstraint(moose2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(moose2ID, edgeCloseConstraint);
		rmAddObjectDefConstraint(moose2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(moose2ID, regionConstraint);
		rmAddObjectDefConstraint(moose2ID, centerCloseConstraint);
		rmAddObjectDefConstraint(moose2ID, Southward);
		rmAddObjectDefConstraint(moose2ID, avoidCloseCliffs);
        rmAddObjectDefConstraint(moose2ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(moose2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(moose2ID, avoidSocket);
	    rmAddObjectDefConstraint(moose2ID, avoidCloseNugget);
        rmSetObjectDefCreateHerd(moose2ID, true);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(moose2ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(moose2ID, 0, 0.5, 0.5, 1.25*cNumberNonGaiaPlayers);		
	    
/*================================================================================================================*/
// ********************************** DEFINE AND PLACE THE SHEEPS ON THE MAP: *********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN SHEEP HERD:
		int sheep1ID=rmCreateObjectDef("sheep herd 1");
        rmAddObjectDefItem(sheep1ID, "sheep", rmRandInt(5,7), 7.0);
        rmSetObjectDefMinDistance(sheep1ID, 0.0);
        rmSetObjectDefMaxDistance(sheep1ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(sheep1ID, avoidVeryFarSheep);
        rmAddObjectDefConstraint(sheep1ID, avoidFarMoose);
		rmAddObjectDefConstraint(sheep1ID, avoidFarDeer);
	    rmAddObjectDefConstraint(sheep1ID, avoidAll);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseFruits);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseCoin);
		rmAddObjectDefConstraint(sheep1ID, edgeCloseConstraint);
		rmAddObjectDefConstraint(sheep1ID, playerCloseConstraint);
		rmAddObjectDefConstraint(sheep1ID, regionConstraint);
		rmAddObjectDefConstraint(sheep1ID, centerCloseConstraint);
		rmAddObjectDefConstraint(sheep1ID, Northward);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseCliffs);
        rmAddObjectDefConstraint(sheep1ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(sheep1ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(sheep1ID, avoidSocket);
	    rmAddObjectDefConstraint(sheep1ID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(sheep1ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(sheep1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2.0);
		else
		rmPlaceObjectDefAtLoc(sheep1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.0);
	    		
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN SHEEP HERD:
		int sheep2ID=rmCreateObjectDef("sheep herd 2");
        rmAddObjectDefItem(sheep2ID, "sheep", rmRandInt(5,9), 7.0);
        rmSetObjectDefMinDistance(sheep2ID, 0.0);
        rmSetObjectDefMaxDistance(sheep2ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(sheep2ID, avoidVeryFarSheep);
        rmAddObjectDefConstraint(sheep2ID, avoidFarMoose);
		rmAddObjectDefConstraint(sheep2ID, avoidFarDeer);
	    rmAddObjectDefConstraint(sheep2ID, avoidAll);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseFruits);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(sheep2ID, edgeCloseConstraint);
		rmAddObjectDefConstraint(sheep2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(sheep2ID, regionConstraint);
		rmAddObjectDefConstraint(sheep2ID, centerCloseConstraint);
		rmAddObjectDefConstraint(sheep2ID, Southward);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseCliffs);
        rmAddObjectDefConstraint(sheep2ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(sheep2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(sheep2ID, avoidSocket);
	    rmAddObjectDefConstraint(sheep2ID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(sheep2ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(sheep2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2.0);
		else
		rmPlaceObjectDefAtLoc(sheep2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.0);

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.75);
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE SOME GEYSERS: *************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.80);
/*================================================================================================================*/
// ********************************* DEFINE AND PLACE SOME PERCHING VULTURES: *********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

       // THE PERCHING VULTURE CONSTRAINTS:
		int vultureID=rmCreateObjectDef("perching vultures 1");
		int avoidVultures=rmCreateTypeDistanceConstraint("avoid other vultures", "PropVulturePerching", 15.0);
	    int avoidCloseVultures=rmCreateTypeDistanceConstraint("close avoid other vultures", "PropVulturePerching", 5.0);
	    int avoidVeryCloseVultures=rmCreateTypeDistanceConstraint("very close avoid other vultures", "PropVulturePerching", 2.0);
	    int avoidFarVultures=rmCreateTypeDistanceConstraint("far avoid other vultures", "PropVulturePerching", 75.0);
	    		
		// THE NORTHERN PERCHING VULTURES:
		rmAddObjectDefItem(vultureID, "PropVulturePerching", 1, 0.0);
	    rmSetObjectDefMinDistance(vultureID, 0.0);
	    rmSetObjectDefMaxDistance(vultureID, rmXFractionToMeters(0.5));
	    rmAddObjectDefConstraint(vultureID, Northward);
	    rmAddObjectDefConstraint(vultureID, regionConstraint);
	    rmAddObjectDefConstraint(vultureID, centerCloseConstraint);
	    rmAddObjectDefConstraint(vultureID, avoidAll);
		rmAddObjectDefConstraint(vultureID, avoidCloseFruits);
		rmAddObjectDefConstraint(vultureID, avoidCloseCoin);
		rmAddObjectDefConstraint(vultureID, avoidFarVultures);
		rmAddObjectDefConstraint(vultureID, avoidCloseCliffs);
		rmAddObjectDefConstraint(vultureID, playerCloseConstraint);
		rmAddObjectDefConstraint(vultureID, avoidCloseMoose);
		rmAddObjectDefConstraint(vultureID, avoidCloseDeer);
	    rmAddObjectDefConstraint(vultureID, avoidCloseNugget);
	    rmAddObjectDefConstraint(vultureID, avoidImpassableLand);
	    rmAddObjectDefConstraint(vultureID, avoidTradeRoute);
	    rmAddObjectDefConstraint(vultureID, avoidSocket);
	    rmAddObjectDefConstraint(vultureID, edgeConstraint);
	    rmPlaceObjectDefAtLoc(vultureID, 0, 0.5, 0.5, 2);
		
		// THE SOUTHERN PERCHING VULTURE:
		int vulture2ID=rmCreateObjectDef("perching vultures 2");
	    rmAddObjectDefItem(vulture2ID, "PropVulturePerching", 1, 0.0);
	    rmSetObjectDefMinDistance(vulture2ID, 0.0);
	    rmSetObjectDefMaxDistance(vulture2ID, rmXFractionToMeters(0.5));
	    rmAddObjectDefConstraint(vulture2ID, Southward);
	    rmAddObjectDefConstraint(vulture2ID, regionConstraint);
	    rmAddObjectDefConstraint(vulture2ID, centerCloseConstraint);
	    rmAddObjectDefConstraint(vulture2ID, avoidAll);
		rmAddObjectDefConstraint(vulture2ID, avoidCloseFruits);
		rmAddObjectDefConstraint(vulture2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(vulture2ID, avoidFarVultures);
		rmAddObjectDefConstraint(vulture2ID, avoidCloseCliffs);
		rmAddObjectDefConstraint(vulture2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(vulture2ID, avoidCloseMoose);
		rmAddObjectDefConstraint(vulture2ID, avoidCloseDeer);
	    rmAddObjectDefConstraint(vulture2ID, avoidCloseNugget);
	    rmAddObjectDefConstraint(vulture2ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(vulture2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(vulture2ID, avoidSocket);
	    rmAddObjectDefConstraint(vulture2ID, edgeConstraint);
	    rmPlaceObjectDefAtLoc(vulture2ID, 0, 0.5, 0.5, 2); 

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.85);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE BISON CARCASS: ************************************** // 		
/*================================================================================================================*/
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.90);
/*================================================================================================================*/
// ************************************** DEFINE AND PLACE THE FORESTS: ***************************************** //		
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

                	
         // THE NORTHERN FOREST:
		 int forestID = 0;
		 
		 if (cNumberNonGaiaPlayers<=2)
		 numTries= 6*cNumberNonGaiaPlayers;
		 else
		 numTries= 4*cNumberNonGaiaPlayers;
		 
         failCount=0;
         
		 for (i=0; <numTries)
      {   
         int forest=rmCreateArea("forest "+i);
         rmSetAreaWarnFailure(forest, false);
         rmSetAreaSize(forest, rmAreaTilesToFraction(225), rmAreaTilesToFraction(425));
         rmSetAreaForestType(forest, "great lakes forest");
		 rmSetAreaForestDensity(forest, 1.0);
         rmSetAreaForestClumpiness(forest, 0.0);
         rmSetAreaForestUnderbrush(forest, 0.0);
         rmSetAreaMinBlobs(forest, 1);
         rmSetAreaMaxBlobs(forest, 1);
         rmSetAreaMinBlobDistance(forest, 1.0);
         rmSetAreaMaxBlobDistance(forest, 1.0);
         rmSetAreaCoherence(forest, 0.85);
         rmSetAreaSmoothDistance(forest, 10);
         rmAddAreaToClass(forest, rmClassID("classForest"));
         rmAddAreaConstraint(forest, edgeCloseConstraint);		 
         rmAddAreaConstraint(forest, forestFarConstraint);
         rmAddAreaConstraint(forest, avoidAll);
		 rmAddAreaConstraint(forest, Northward);
		 rmAddAreaConstraint(forest, avoidCloseVultures);
		 rmAddAreaConstraint(forest, avoidCloseMoose);
		 rmAddAreaConstraint(forest, avoidCloseDeer);
		 rmAddAreaConstraint(forest, avoidCloseSheep);
		 rmAddAreaConstraint(forest, avoidCloseFruits);
		 rmAddAreaConstraint(forest, avoidCloseNugget);
		 rmAddAreaConstraint(forest, avoidCloseCoin);
		 rmAddAreaConstraint(forest, centerCloseConstraint);
		 rmAddAreaConstraint(forest, regionCloseConstraint);
		 rmAddAreaConstraint(forest, avoidCloseCliffs);
		 rmAddAreaConstraint(forest, playerCloseConstraint);
         rmAddAreaConstraint(forest, avoidCloseImpassableLand); 
         rmAddAreaConstraint(forest, avoidVeryCloseTradeRoute); 
		 rmAddAreaConstraint(forest, avoidVeryCloseSocket); 
		 if(rmBuildArea(forest)==false)
    {
         // Stop trying once we fail 3 times in a row.
         failCount++;
         if(failCount==5)
         break;
    }
         else
         failCount=0; 
}  

/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN FOREST:
		 forestID = 0;
		 
		 if (cNumberNonGaiaPlayers<=2)
		 numTries= 6*cNumberNonGaiaPlayers;
		 else
		 numTries= 4*cNumberNonGaiaPlayers;
		 
         failCount=0;
         
		 for (i=0; <numTries)
      {   
         int forest2=rmCreateArea("forest 2"+i);
         rmSetAreaWarnFailure(forest2, false);
         rmSetAreaSize(forest2, rmAreaTilesToFraction(225), rmAreaTilesToFraction(425));
         rmSetAreaForestType(forest2, "great lakes forest");
		 rmSetAreaForestDensity(forest2, 1.0);
         rmSetAreaForestClumpiness(forest2, 0.0);
         rmSetAreaForestUnderbrush(forest2, 0.0);
         rmSetAreaMinBlobs(forest2, 1);
         rmSetAreaMaxBlobs(forest2, 1);
         rmSetAreaMinBlobDistance(forest2, 1.0);
         rmSetAreaMaxBlobDistance(forest2, 1.0);
         rmSetAreaCoherence(forest2, 0.85);
         rmSetAreaSmoothDistance(forest2, 10);
         rmAddAreaToClass(forest2, rmClassID("classForest"));
         rmAddAreaConstraint(forest2, edgeCloseConstraint);		 
         rmAddAreaConstraint(forest2, forestFarConstraint);
         rmAddAreaConstraint(forest2, avoidAll);
		 rmAddAreaConstraint(forest2, Southward);
		 rmAddAreaConstraint(forest2, avoidVultures);
		 rmAddAreaConstraint(forest2, avoidCloseMoose);
		 rmAddAreaConstraint(forest2, avoidCloseDeer);
		 rmAddAreaConstraint(forest2, avoidCloseSheep);
		 rmAddAreaConstraint(forest2, avoidCloseFruits);
		 rmAddAreaConstraint(forest2, avoidCloseNugget);
		 rmAddAreaConstraint(forest2, avoidCloseCoin);
		 rmAddAreaConstraint(forest2, centerCloseConstraint);
		 rmAddAreaConstraint(forest2, regionCloseConstraint);
		 rmAddAreaConstraint(forest2, avoidCloseCliffs);
		 rmAddAreaConstraint(forest2, playerCloseConstraint);
         rmAddAreaConstraint(forest2, avoidCloseImpassableLand); 
         rmAddAreaConstraint(forest2, avoidVeryCloseTradeRoute); 
		 rmAddAreaConstraint(forest2, avoidVeryCloseSocket); 
		 if(rmBuildArea(forest2)==false)
    {
         // Stop trying once we fail 3 times in a row.
         failCount++;
         if(failCount==5)
         break;
    }
         else
         failCount=0; 
} 


/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.95);
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE WOOD RESOURCES: *********************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        // RANDOM TREES FOR THE NORTH REGION:
		int randomTreeID=rmCreateObjectDef("random tree 1");
		rmAddObjectDefItem(randomTreeID, "TreeGreatLakes", 1, 0.0);
		rmAddObjectDefToClass(randomTreeID, rmClassID("classTrees"));
		rmSetObjectDefMinDistance(randomTreeID, 0.0);
        rmSetObjectDefMaxDistance(randomTreeID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(randomTreeID, regionCloseConstraint);
 		rmAddObjectDefConstraint(randomTreeID, edgeCloseConstraint); 
	    rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseTradeRoute);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseSocket);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseImportantItem);
	    rmAddObjectDefConstraint(randomTreeID, avoidAll);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseVultures);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseSheep);
		rmAddObjectDefConstraint(randomTreeID, forestCloseConstraint);
		rmAddObjectDefConstraint(randomTreeID, centerCloseConstraint);
		rmAddObjectDefConstraint(randomTreeID, playerCloseConstraint);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseDeer);
	    rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseMoose);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseTrees);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseCoin);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseNugget);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseCliffs);
		rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseFruits);
	    rmAddObjectDefConstraint(randomTreeID, avoidVeryCloseImpassableLand);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(randomTreeID, 0, 0.5, 0.5, 24*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(randomTreeID, 0, 0.5, 0.5, 15*cNumberNonGaiaPlayers);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // RANDOM TREES FOR THE SOUTH REGION:
		int randomTree2ID=rmCreateObjectDef("random tree 2");
		rmAddObjectDefItem(randomTree2ID, "TreeGreatLakes", 1, 0.0);
		rmAddObjectDefToClass(randomTree2ID, rmClassID("classTrees"));
		rmSetObjectDefMinDistance(randomTree2ID, 0.0);
        rmSetObjectDefMaxDistance(randomTree2ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(randomTree2ID, regionCloseConstraint);
 		rmAddObjectDefConstraint(randomTree2ID, edgeCloseConstraint); 
	    rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseTradeRoute);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseSocket);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseImportantItem);
	    rmAddObjectDefConstraint(randomTree2ID, avoidAll);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseVultures);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseSheep);
		rmAddObjectDefConstraint(randomTree2ID, forestVeryCloseConstraint);
		rmAddObjectDefConstraint(randomTree2ID, centerCloseConstraint);
		rmAddObjectDefConstraint(randomTree2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseDeer);
	    rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseMoose);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseTrees);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseCoin);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseNugget);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseCliffs);
		rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseFruits);
	    rmAddObjectDefConstraint(randomTree2ID, avoidVeryCloseImpassableLand);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(randomTree2ID, 0, 0.5, 0.5, 24*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(randomTree2ID, 0, 0.5, 0.5, 15*cNumberNonGaiaPlayers);
		
/*================================================================================================================*/
// *************************** DEFINE AND PLACE THE SILVER MINES ON THE BONUS ISLAND: *************************** //
/*================================================================================================================*/		

        // THE BONUS ISLAND MINES:
		int Coins3ID= rmCreateObjectDef("The Coins 3"); 
	    rmAddObjectDefItem(Coins3ID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(Coins3ID, 0.0);
	    rmSetObjectDefMaxDistance(Coins3ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(Coins3ID, avoidFarCoin);
		rmAddObjectDefConstraint(Coins3ID, avoidCloseImpassableLand);
		rmAddObjectDefConstraint(Coins3ID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(Coins3ID, bonusIslandConstraint);
		rmAddObjectDefConstraint(Coins3ID, avoidAll);
	    
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(Coins3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.0);
		else
		rmPlaceObjectDefAtLoc(Coins3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*0.50);

/*================================================================================================================*/
// ***************************** DEFINE AND PLACE THE NUGGETS ON THE BONUS ISLAND: ****************************** //     		
/*================================================================================================================*/

        // THE BONUS ISLAND NUGGETS:
		int nugget3ID= rmCreateObjectDef("nugget 3"); 
	    rmAddObjectDefItem(nugget3ID, "Nugget", 1, 0.0);
	    rmSetObjectDefMinDistance(nugget3ID, 0.0);
	    rmSetObjectDefMaxDistance(nugget3ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(nugget3ID, avoidCloseImpassableLand);
  	    rmAddObjectDefConstraint(nugget3ID, avoidFarNugget);
		rmAddObjectDefConstraint(nugget3ID, avoidCloseCoin);
		rmAddObjectDefConstraint(nugget3ID, playerCloseConstraint);
  	    rmAddObjectDefConstraint(nugget3ID, bonusIslandConstraint);
  	    rmAddObjectDefConstraint(nugget3ID, avoidAll);
	    
		rmSetNuggetDifficulty(1, 4);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(nugget3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.0);
		else
		rmPlaceObjectDefAtLoc(nugget3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*0.50);
		
/*================================================================================================================*/
// **************************** DEFINE AND PLACE SOME BERRYBUSH ON THE BONUS ISLAND: **************************** //		
/*================================================================================================================*/

        // THE NORTHERN BERRYBUSH:
		int Berries3ID=rmCreateObjectDef("The Berries 3");
        rmAddObjectDefItem(Berries3ID, "berrybush", rmRandInt(3,7), 8.0);
        rmSetObjectDefMinDistance(Berries3ID, 0.0);
        rmSetObjectDefMaxDistance(Berries3ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(Berries3ID, avoidFarFruits);
		rmAddObjectDefConstraint(Berries3ID, avoidCloseCoin);
		rmAddObjectDefConstraint(Berries3ID, avoidAll);
		rmAddObjectDefConstraint(Berries3ID, playerCloseConstraint);
		rmAddObjectDefConstraint(Berries3ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(Berries3ID, bonusIslandConstraint);
	    rmAddObjectDefConstraint(Berries3ID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(Berries3ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(Berries3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.0);
		else
		rmPlaceObjectDefAtLoc(Berries3ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*0.5);
		
/*================================================================================================================*/
// **************************** DEFINE AND PLACE SOME DEER HERDS ON THE BONUS ISLAND: *************************** //		
/*================================================================================================================*/

        // THE BONUS ISLAND DEER HERDS:
		int deer3ID=rmCreateObjectDef("deer herd 3");
        rmAddObjectDefItem(deer3ID, "deer", rmRandInt(6,9), 10.0);
        rmSetObjectDefMinDistance(deer3ID, 0.0);
        rmSetObjectDefMaxDistance(deer3ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(deer3ID, avoidFarDeer);
	    rmAddObjectDefConstraint(deer3ID, avoidAll);
		rmAddObjectDefConstraint(deer3ID, avoidCloseFruits);
		rmAddObjectDefConstraint(deer3ID, avoidCloseCoin);
		rmAddObjectDefConstraint(deer3ID, playerCloseConstraint);
		rmAddObjectDefConstraint(deer3ID, avoidImpassableLand);
	    rmAddObjectDefConstraint(deer3ID, bonusIslandConstraint);
	    rmAddObjectDefConstraint(deer3ID, avoidCloseNugget);
        
		rmSetObjectDefCreateHerd(deer3ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(deer3ID, 0, 0.5, 0.5, 1.0*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(deer3ID, 0, 0.5, 0.5, 0.50*cNumberNonGaiaPlayers);
		
/*================================================================================================================*/
// ************************** DEFINE AND PLACE SOME RANDOM TREES ON THE BONUS ISLAND: *************************** //
/*================================================================================================================*/

        // THE BONUS ISLAND RANDOM TREES:
		int randomTree3ID=rmCreateObjectDef("random tree 3");
		rmAddObjectDefItem(randomTree3ID, "TreeGreatLakes", rmRandInt(15,21), 10.0);
		rmAddObjectDefToClass(randomTree3ID, rmClassID("classTrees"));
		rmSetObjectDefMinDistance(randomTree3ID, 0.0);
        rmSetObjectDefMaxDistance(randomTree3ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(randomTree3ID, avoidAll);
		rmAddObjectDefConstraint(randomTree3ID, playerCloseConstraint);
		rmAddObjectDefConstraint(randomTree3ID, avoidCloseDeer);
	    rmAddObjectDefConstraint(randomTree3ID, avoidMediumTrees);
		rmAddObjectDefConstraint(randomTree3ID, avoidCloseCoin);
		rmAddObjectDefConstraint(randomTree3ID, avoidCloseNugget);
		rmAddObjectDefConstraint(randomTree3ID, avoidCloseFruits);
	    rmAddObjectDefConstraint(randomTree3ID, avoidImpassableLand);
		rmAddObjectDefConstraint(randomTree3ID, bonusIslandConstraint);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(randomTree3ID, 0, 0.5, 0.5, 5.0*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(randomTree3ID, 0, 0.5, 0.5, 2.0*cNumberNonGaiaPlayers);		

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.95);
/*================================================================================================================*/
// ************************************* DEFINE AND PLACE THE FISHBASS: **************************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

        int fishID=rmCreateObjectDef("fish");
        rmAddObjectDefItem(fishID, "FishBass", 3, 9.0);
        rmSetObjectDefMinDistance(fishID, 0.0);
        rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(fishID, fishVsFishID);
        rmAddObjectDefConstraint(fishID, fishLand);
        rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 25*cNumberNonGaiaPlayers);

/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE WHALES: ***************************************** //
/*================================================================================================================*/
       
	    // FAST COIN -- WHALES
	    int whaleID=rmCreateObjectDef("whale");
        rmAddObjectDefItem(whaleID, "minkeWhale", 1, 9.0);
        rmSetObjectDefMinDistance(whaleID, 0.0);
        rmSetObjectDefMaxDistance(whaleID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(whaleID, whaleVsWhaleID);
        rmAddObjectDefConstraint(whaleID, whaleLand);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 1.25*cNumberNonGaiaPlayers);		

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",1.00);
/*===============================================================================================================*/
}
/*===============================================================================================================*/
// ************************************** THIS IS THE END OF THE MAP: ****************************************** //
/*===============================================================================================================*/		
